//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.Diagnostics;

namespace Buckets
{
	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class BucketForm : System.Windows.Forms.Form
	{
		private const int readerCount = 5;
		private const int writerCount = 5;
		private const int numberOfBallColors = 9;
		private Thread [] readerThreads;
		private Thread [] writerThreads;
		private Hashtable threadHashtable;
		private Hashtable ballsHashtable;
		private ReaderWriterLock readerWriterLock;
		private delegate void BucketUpdateDelegate(int [] ballSnapShot, int readerId, int timeStamp);
		private BucketUpdateDelegate bucketUpdateDelegate;
		private int [] readerTimeStamp;
		private int [] writerTimeStamp;
		private Random r;

		private System.Windows.Forms.Label totalLabel;
		private System.Windows.Forms.Label grayLabel;
		private System.Windows.Forms.Label cyanLabel;
		private System.Windows.Forms.Label orangeLabel;
		private System.Windows.Forms.Label yellowLabel;
		private System.Windows.Forms.Label whiteLabel;
		private System.Windows.Forms.Label blueLabel;
		private System.Windows.Forms.Label greenLabel;
		private System.Windows.Forms.Label redLabel;
		private System.Windows.Forms.Label blackLabel;
		private System.Windows.Forms.TextBox total1;
		private System.Windows.Forms.TextBox total2;
		private System.Windows.Forms.TextBox total3;
		private System.Windows.Forms.TextBox total4;
		private System.Windows.Forms.TextBox total5;
		private System.Windows.Forms.TextBox gray1;
		private System.Windows.Forms.TextBox gray2;
		private System.Windows.Forms.TextBox gray3;
		private System.Windows.Forms.TextBox gray4;
		private System.Windows.Forms.TextBox gray5;
		private System.Windows.Forms.TextBox cyan1;
		private System.Windows.Forms.TextBox cyan2;
		private System.Windows.Forms.TextBox cyan3;
		private System.Windows.Forms.TextBox cyan4;
		private System.Windows.Forms.TextBox cyan5;
		private System.Windows.Forms.TextBox orange1;
		private System.Windows.Forms.TextBox orange2;
		private System.Windows.Forms.TextBox orange3;
		private System.Windows.Forms.TextBox orange4;
		private System.Windows.Forms.TextBox orange5;
		private System.Windows.Forms.TextBox yellow1;
		private System.Windows.Forms.TextBox yellow2;
		private System.Windows.Forms.TextBox yellow3;
		private System.Windows.Forms.TextBox yellow4;
		private System.Windows.Forms.TextBox yellow5;
		private System.Windows.Forms.TextBox white1;
		private System.Windows.Forms.TextBox white2;
		private System.Windows.Forms.TextBox white3;
		private System.Windows.Forms.TextBox white4;
		private System.Windows.Forms.TextBox white5;
		private System.Windows.Forms.TextBox blue1;
		private System.Windows.Forms.TextBox blue2;
		private System.Windows.Forms.TextBox blue3;
		private System.Windows.Forms.TextBox blue4;
		private System.Windows.Forms.TextBox blue5;
		private System.Windows.Forms.TextBox green1;
		private System.Windows.Forms.TextBox green2;
		private System.Windows.Forms.TextBox green3;
		private System.Windows.Forms.TextBox green4;
		private System.Windows.Forms.TextBox green5;
		private System.Windows.Forms.TextBox red1;
		private System.Windows.Forms.TextBox red2;
		private System.Windows.Forms.TextBox red3;
		private System.Windows.Forms.TextBox red4;
		private System.Windows.Forms.TextBox red5;
		private System.Windows.Forms.TextBox black1;
		private System.Windows.Forms.TextBox black2;
		private System.Windows.Forms.TextBox black3;
		private System.Windows.Forms.TextBox black4;
		private System.Windows.Forms.TextBox black5;
		private System.Windows.Forms.TextBox readWriteTimeDifference1;
		private System.Windows.Forms.TextBox readWriteTimeDifference2;
		private System.Windows.Forms.TextBox readWriteTimeDifference3;
		private System.Windows.Forms.TextBox readWriteTimeDifference4;
		private System.Windows.Forms.TextBox readWriteTimeDifference5;
		private System.Windows.Forms.Button suspendButton;
		private System.Windows.Forms.Button resumeButton;
		private System.Windows.Forms.Button exitButton;
		private System.Windows.Forms.Label readWriteTimeLabel;
		private System.Windows.Forms.Label timeLabel1;
		private System.Windows.Forms.Label timeLabel2;
		private System.Windows.Forms.Label timeLabel3;
		private System.Windows.Forms.Label timeLabel4;
		private System.Windows.Forms.Label timeLabel5;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public BucketForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			readerThreads = new Thread[readerCount];
			writerThreads = new Thread[writerCount];
			readerTimeStamp = new int[readerCount];
			writerTimeStamp = new int[writerCount];
			readerWriterLock = new ReaderWriterLock();
			threadHashtable = Hashtable.Synchronized(new Hashtable());
			ballsHashtable = new Hashtable();
			bucketUpdateDelegate = new BucketUpdateDelegate(OnBucketUpdate);
			r = new Random();

			for(int i = 0; i < readerCount; i++)
			{
				readerThreads[i] = new Thread(new ThreadStart(ReadBucket));
				readerThreads[i].Name = "Reader " + Convert.ToString(i);
				threadHashtable.Add(readerThreads[i].GetHashCode(), i);
			}
			for(int i = 0; i < writerCount; i++)
			{
				writerThreads[i] = new Thread(new ThreadStart(WriteBucket));
				writerThreads[i].Name = "Writer " + Convert.ToString(i);
				threadHashtable.Add(writerThreads[i].GetHashCode(), i);
			}
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		void OnBucketUpdate(int [] ballSnapShot, int readerId, int timeStamp)
		{
			switch(readerId)
			{
				case 0:
					black1.Text = Convert.ToString(ballSnapShot[0]);
					red1.Text = Convert.ToString(ballSnapShot[1]);
					green1.Text = Convert.ToString(ballSnapShot[2]);
					blue1.Text = Convert.ToString(ballSnapShot[3]);
					white1.Text = Convert.ToString(ballSnapShot[4]);
					yellow1.Text = Convert.ToString(ballSnapShot[5]);
					orange1.Text = Convert.ToString(ballSnapShot[6]);
					cyan1.Text = Convert.ToString(ballSnapShot[7]);
					gray1.Text = Convert.ToString(ballSnapShot[8]);
					total1.Text = Convert.ToString(ballSnapShot[0] + 
						                           ballSnapShot[1] +
						                           ballSnapShot[2] +
						                           ballSnapShot[3] +
						                           ballSnapShot[4] +
						                           ballSnapShot[5] +
						                           ballSnapShot[6] +
						                           ballSnapShot[7] +
						                           ballSnapShot[8]);
					readWriteTimeDifference1.Text = Convert.ToString(timeStamp);
					black1.Refresh();
					red1.Refresh();
					green1.Refresh();
					blue1.Refresh();
					white1.Refresh();
					yellow1.Refresh();
					orange1.Refresh();
					cyan1.Refresh();
					gray1.Refresh();
					total1.Refresh();
					readWriteTimeDifference1.Refresh();
					break;
				case 1:
					black2.Text = Convert.ToString(ballSnapShot[0]);
					red2.Text = Convert.ToString(ballSnapShot[1]);
					green2.Text = Convert.ToString(ballSnapShot[2]);
					blue2.Text = Convert.ToString(ballSnapShot[3]);
					white2.Text = Convert.ToString(ballSnapShot[4]);
					yellow2.Text = Convert.ToString(ballSnapShot[5]);
					orange2.Text = Convert.ToString(ballSnapShot[6]);
					cyan2.Text = Convert.ToString(ballSnapShot[7]);
					gray2.Text = Convert.ToString(ballSnapShot[8]);
					total2.Text = Convert.ToString(ballSnapShot[0] + 
						                           ballSnapShot[1] +
						                           ballSnapShot[2] +
						                           ballSnapShot[3] +
						                           ballSnapShot[4] +
						                           ballSnapShot[5] +
						                           ballSnapShot[6] +
						                           ballSnapShot[7] +
						                           ballSnapShot[8]);
					readWriteTimeDifference2.Text = Convert.ToString(timeStamp);
					black2.Refresh();
					red2.Refresh();
					green2.Refresh();
					blue2.Refresh();
					white2.Refresh();
					yellow2.Refresh();
					orange2.Refresh();
					cyan2.Refresh();
					gray2.Refresh();
					total2.Refresh();
					readWriteTimeDifference2.Refresh();
					break;
				case 2:
					black3.Text = Convert.ToString(ballSnapShot[0]);
					red3.Text = Convert.ToString(ballSnapShot[1]);
					green3.Text = Convert.ToString(ballSnapShot[2]);
					blue3.Text = Convert.ToString(ballSnapShot[3]);
					white3.Text = Convert.ToString(ballSnapShot[4]);
					yellow3.Text = Convert.ToString(ballSnapShot[5]);
					orange3.Text = Convert.ToString(ballSnapShot[6]);
					cyan3.Text = Convert.ToString(ballSnapShot[7]);
					gray3.Text = Convert.ToString(ballSnapShot[8]);
					total3.Text = Convert.ToString(ballSnapShot[0] + 
						                           ballSnapShot[1] +
						                           ballSnapShot[2] +
						                           ballSnapShot[3] +
						                           ballSnapShot[4] +
						                           ballSnapShot[5] +
						                           ballSnapShot[6] +
						                           ballSnapShot[7] +
						                           ballSnapShot[8]);
					readWriteTimeDifference3.Text = Convert.ToString(timeStamp);
					black3.Refresh();
					red3.Refresh();
					green3.Refresh();
					blue3.Refresh();
					white3.Refresh();
					yellow3.Refresh();
					orange3.Refresh();
					cyan3.Refresh();
					gray3.Refresh();
					total3.Refresh();
					readWriteTimeDifference3.Refresh();
					break;
				case 3:
					black4.Text = Convert.ToString(ballSnapShot[0]);
					red4.Text = Convert.ToString(ballSnapShot[1]);
					green4.Text = Convert.ToString(ballSnapShot[2]);
					blue4.Text = Convert.ToString(ballSnapShot[3]);
					white4.Text = Convert.ToString(ballSnapShot[4]);
					yellow4.Text = Convert.ToString(ballSnapShot[5]);
					orange4.Text = Convert.ToString(ballSnapShot[6]);
					cyan4.Text = Convert.ToString(ballSnapShot[7]);
					gray4.Text = Convert.ToString(ballSnapShot[8]);
					total4.Text = Convert.ToString(ballSnapShot[0] + 
						                           ballSnapShot[1] +
						                           ballSnapShot[2] +
						                           ballSnapShot[3] +
						                           ballSnapShot[4] +
						                           ballSnapShot[5] +
						                           ballSnapShot[6] +
						                           ballSnapShot[7] +
						                           ballSnapShot[8]);
					readWriteTimeDifference4.Text = Convert.ToString(timeStamp);
					black4.Refresh();
					red4.Refresh();
					green4.Refresh();
					blue4.Refresh();
					white4.Refresh();
					yellow4.Refresh();
					orange4.Refresh();
					cyan4.Refresh();
					gray4.Refresh();
					total4.Refresh();
					readWriteTimeDifference4.Refresh();
					break;
				case 4:
					black5.Text = Convert.ToString(ballSnapShot[0]);
					red5.Text = Convert.ToString(ballSnapShot[1]);
					green5.Text = Convert.ToString(ballSnapShot[2]);
					blue5.Text = Convert.ToString(ballSnapShot[3]);
					white5.Text = Convert.ToString(ballSnapShot[4]);
					yellow5.Text = Convert.ToString(ballSnapShot[5]);
					orange5.Text = Convert.ToString(ballSnapShot[6]);
					cyan5.Text = Convert.ToString(ballSnapShot[7]);
					gray5.Text = Convert.ToString(ballSnapShot[8]);
					total5.Text = Convert.ToString(ballSnapShot[0] + 
						                           ballSnapShot[1] +
						                           ballSnapShot[2] +
						                           ballSnapShot[3] +
						                           ballSnapShot[4] +
						                           ballSnapShot[5] +
						                           ballSnapShot[6] +
						                           ballSnapShot[7] +
						                           ballSnapShot[8]);
					readWriteTimeDifference5.Text = Convert.ToString(timeStamp);
					black5.Refresh();
					red5.Refresh();
					green5.Refresh();
					blue5.Refresh();
					white5.Refresh();
					yellow5.Refresh();
					orange5.Refresh();
					cyan5.Refresh();
					gray5.Refresh();
					total5.Refresh();
					readWriteTimeDifference5.Refresh();
					break;
			}
		}

		void ReadBucket()
		{
			int [] bucketSnapShot = new int[numberOfBallColors];
			int id = (int)threadHashtable[Thread.CurrentThread.GetHashCode()];
			while(true)
			{
				Thread.Sleep(r.Next(5000));

				readerWriterLock.AcquireReaderLock(-1);

				bucketSnapShot[0] = ballsHashtable.ContainsKey(Color.Black) ? 
					(int)ballsHashtable[Color.Black] : 0;
				bucketSnapShot[1] = ballsHashtable.ContainsKey(Color.Red) ? 
					(int)ballsHashtable[Color.Red] : 0;
				bucketSnapShot[2] = ballsHashtable.ContainsKey(Color.Green) ? 
					(int)ballsHashtable[Color.Green] : 0;
				bucketSnapShot[3] = ballsHashtable.ContainsKey(Color.Blue) ? 
					(int)ballsHashtable[Color.Blue] : 0;
				bucketSnapShot[4] = ballsHashtable.ContainsKey(Color.White) ? 
					(int)ballsHashtable[Color.White] : 0;
				bucketSnapShot[5] = ballsHashtable.ContainsKey(Color.Yellow) ? 
					(int)ballsHashtable[Color.Yellow] : 0;
				bucketSnapShot[6] = ballsHashtable.ContainsKey(Color.Orange) ? 
					(int)ballsHashtable[Color.Orange] : 0;
				bucketSnapShot[7] = ballsHashtable.ContainsKey(Color.Cyan) ? 
					(int)ballsHashtable[Color.Cyan] : 0;
				bucketSnapShot[8] = ballsHashtable.ContainsKey(Color.Gray) ? 
					(int)ballsHashtable[Color.Gray] : 0;

				readerTimeStamp[id] = Environment.TickCount;

				BeginInvoke(bucketUpdateDelegate, new object[] {bucketSnapShot, id, writerTimeStamp[id] > 0 ? readerTimeStamp[id] - writerTimeStamp[id] : 0});

				readerWriterLock.ReleaseReaderLock();
			}
		}

		void WriteBucket()
		{
			int id = (int)threadHashtable[Thread.CurrentThread.GetHashCode()];
			int randomColor;
			while(true)
			{
				Thread.Sleep(r.Next(5000));
				readerWriterLock.AcquireWriterLock(-1);
				randomColor = r.Next(numberOfBallColors);
				switch(randomColor)
				{
					case 0:
						if(ballsHashtable.ContainsKey(Color.Black))
						{
							ballsHashtable[Color.Black] = (int)ballsHashtable[Color.Black] + 1;
						}
						else
						{
							ballsHashtable[Color.Black] = 1;
						}
						break;
					case 1:
						if(ballsHashtable.ContainsKey(Color.Red))
						{
							ballsHashtable[Color.Red] = (int)ballsHashtable[Color.Red] + 1;
						}
						else
						{
							ballsHashtable[Color.Red] = 1;
						}
						break;
					case 2:
						if(ballsHashtable.ContainsKey(Color.Green))
						{
							ballsHashtable[Color.Green] = (int)ballsHashtable[Color.Green] + 1;
						}
						else
						{
							ballsHashtable[Color.Green] = 1;
						}
						break;
					case 3:
						if(ballsHashtable.ContainsKey(Color.Blue))
						{
							ballsHashtable[Color.Blue] = (int)ballsHashtable[Color.Blue] + 1;
						}
						else
						{
							ballsHashtable[Color.Blue] = 1;
						}
						break;
					case 4:
						if(ballsHashtable.ContainsKey(Color.White))
						{
							ballsHashtable[Color.White] = (int)ballsHashtable[Color.White] + 1;
						}
						else
						{
							ballsHashtable[Color.White] = 1;
						}
						break;
					case 5:
						if(ballsHashtable.ContainsKey(Color.Yellow))
						{
							ballsHashtable[Color.Yellow] = (int)ballsHashtable[Color.Yellow] + 1;
						}
						else
						{
							ballsHashtable[Color.Yellow] = 1;
						}
						break;
					case 6:
						if(ballsHashtable.ContainsKey(Color.Orange))
						{
							ballsHashtable[Color.Orange] = (int)ballsHashtable[Color.Orange] + 1;
						}
						else
						{
							ballsHashtable[Color.Orange] = 1;
						}
						break;
					case 7:
						if(ballsHashtable.ContainsKey(Color.Cyan))
						{
							ballsHashtable[Color.Cyan] = (int)ballsHashtable[Color.Cyan] + 1;
						}
						else
						{
							ballsHashtable[Color.Cyan] = 1;
						}
						break;
					case 8:
						if(ballsHashtable.ContainsKey(Color.Gray))
						{
							ballsHashtable[Color.Gray] = (int)ballsHashtable[Color.Gray] + 1;
						}
						else
						{
							ballsHashtable[Color.Gray] = 1;
						}
						break;
				}

				writerTimeStamp[id] = Environment.TickCount;

				readerWriterLock.ReleaseWriterLock();
			}
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.green1 = new System.Windows.Forms.TextBox();
			this.orangeLabel = new System.Windows.Forms.Label();
			this.green3 = new System.Windows.Forms.TextBox();
			this.green2 = new System.Windows.Forms.TextBox();
			this.green5 = new System.Windows.Forms.TextBox();
			this.green4 = new System.Windows.Forms.TextBox();
			this.readWriteTimeDifference5 = new System.Windows.Forms.TextBox();
			this.readWriteTimeDifference4 = new System.Windows.Forms.TextBox();
			this.readWriteTimeDifference3 = new System.Windows.Forms.TextBox();
			this.readWriteTimeDifference2 = new System.Windows.Forms.TextBox();
			this.readWriteTimeDifference1 = new System.Windows.Forms.TextBox();
			this.resumeButton = new System.Windows.Forms.Button();
			this.suspendButton = new System.Windows.Forms.Button();
			this.cyan5 = new System.Windows.Forms.TextBox();
			this.cyan4 = new System.Windows.Forms.TextBox();
			this.cyan3 = new System.Windows.Forms.TextBox();
			this.cyan2 = new System.Windows.Forms.TextBox();
			this.grayLabel = new System.Windows.Forms.Label();
			this.total5 = new System.Windows.Forms.TextBox();
			this.timeLabel1 = new System.Windows.Forms.Label();
			this.timeLabel3 = new System.Windows.Forms.Label();
			this.timeLabel2 = new System.Windows.Forms.Label();
			this.timeLabel5 = new System.Windows.Forms.Label();
			this.timeLabel4 = new System.Windows.Forms.Label();
			this.total1 = new System.Windows.Forms.TextBox();
			this.total2 = new System.Windows.Forms.TextBox();
			this.total3 = new System.Windows.Forms.TextBox();
			this.total4 = new System.Windows.Forms.TextBox();
			this.cyanLabel = new System.Windows.Forms.Label();
			this.yellow4 = new System.Windows.Forms.TextBox();
			this.blue4 = new System.Windows.Forms.TextBox();
			this.blue5 = new System.Windows.Forms.TextBox();
			this.exitButton = new System.Windows.Forms.Button();
			this.red5 = new System.Windows.Forms.TextBox();
			this.red4 = new System.Windows.Forms.TextBox();
			this.blue1 = new System.Windows.Forms.TextBox();
			this.blue2 = new System.Windows.Forms.TextBox();
			this.blue3 = new System.Windows.Forms.TextBox();
			this.readWriteTimeLabel = new System.Windows.Forms.Label();
			this.gray5 = new System.Windows.Forms.TextBox();
			this.black5 = new System.Windows.Forms.TextBox();
			this.blackLabel = new System.Windows.Forms.Label();
			this.yellow3 = new System.Windows.Forms.TextBox();
			this.black1 = new System.Windows.Forms.TextBox();
			this.black3 = new System.Windows.Forms.TextBox();
			this.black2 = new System.Windows.Forms.TextBox();
			this.cyan1 = new System.Windows.Forms.TextBox();
			this.redLabel = new System.Windows.Forms.Label();
			this.orange2 = new System.Windows.Forms.TextBox();
			this.orange3 = new System.Windows.Forms.TextBox();
			this.orange1 = new System.Windows.Forms.TextBox();
			this.orange4 = new System.Windows.Forms.TextBox();
			this.orange5 = new System.Windows.Forms.TextBox();
			this.totalLabel = new System.Windows.Forms.Label();
			this.blueLabel = new System.Windows.Forms.Label();
			this.black4 = new System.Windows.Forms.TextBox();
			this.white2 = new System.Windows.Forms.TextBox();
			this.yellowLabel = new System.Windows.Forms.Label();
			this.white5 = new System.Windows.Forms.TextBox();
			this.white4 = new System.Windows.Forms.TextBox();
			this.white1 = new System.Windows.Forms.TextBox();
			this.white3 = new System.Windows.Forms.TextBox();
			this.greenLabel = new System.Windows.Forms.Label();
			this.gray4 = new System.Windows.Forms.TextBox();
			this.gray3 = new System.Windows.Forms.TextBox();
			this.gray2 = new System.Windows.Forms.TextBox();
			this.gray1 = new System.Windows.Forms.TextBox();
			this.yellow5 = new System.Windows.Forms.TextBox();
			this.yellow2 = new System.Windows.Forms.TextBox();
			this.whiteLabel = new System.Windows.Forms.Label();
			this.yellow1 = new System.Windows.Forms.TextBox();
			this.red1 = new System.Windows.Forms.TextBox();
			this.red3 = new System.Windows.Forms.TextBox();
			this.red2 = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// green1
			// 
			this.green1.Location = new System.Drawing.Point(143, 69);
			this.green1.Name = "green1";
			this.green1.ReadOnly = true;
			this.green1.Size = new System.Drawing.Size(72, 22);
			this.green1.TabIndex = 2;
			this.green1.Text = "";
			// 
			// orangeLabel
			// 
			this.orangeLabel.BackColor = System.Drawing.Color.Orange;
			this.orangeLabel.Location = new System.Drawing.Point(10, 188);
			this.orangeLabel.Name = "orangeLabel";
			this.orangeLabel.Size = new System.Drawing.Size(128, 19);
			this.orangeLabel.TabIndex = 1;
			this.orangeLabel.Text = "Pomaraczowa";
			// 
			// green3
			// 
			this.green3.Location = new System.Drawing.Point(307, 69);
			this.green3.Name = "green3";
			this.green3.ReadOnly = true;
			this.green3.Size = new System.Drawing.Size(72, 22);
			this.green3.TabIndex = 2;
			this.green3.Text = "";
			// 
			// green2
			// 
			this.green2.Location = new System.Drawing.Point(225, 69);
			this.green2.Name = "green2";
			this.green2.ReadOnly = true;
			this.green2.Size = new System.Drawing.Size(72, 22);
			this.green2.TabIndex = 2;
			this.green2.Text = "";
			// 
			// green5
			// 
			this.green5.Location = new System.Drawing.Point(471, 69);
			this.green5.Name = "green5";
			this.green5.ReadOnly = true;
			this.green5.Size = new System.Drawing.Size(72, 22);
			this.green5.TabIndex = 2;
			this.green5.Text = "";
			// 
			// green4
			// 
			this.green4.Location = new System.Drawing.Point(389, 69);
			this.green4.Name = "green4";
			this.green4.ReadOnly = true;
			this.green4.Size = new System.Drawing.Size(72, 22);
			this.green4.TabIndex = 2;
			this.green4.Text = "";
			// 
			// readWriteTimeDifference5
			// 
			this.readWriteTimeDifference5.Location = new System.Drawing.Point(471, 336);
			this.readWriteTimeDifference5.Name = "readWriteTimeDifference5";
			this.readWriteTimeDifference5.ReadOnly = true;
			this.readWriteTimeDifference5.Size = new System.Drawing.Size(72, 22);
			this.readWriteTimeDifference5.TabIndex = 2;
			this.readWriteTimeDifference5.Text = "";
			// 
			// readWriteTimeDifference4
			// 
			this.readWriteTimeDifference4.Location = new System.Drawing.Point(389, 336);
			this.readWriteTimeDifference4.Name = "readWriteTimeDifference4";
			this.readWriteTimeDifference4.ReadOnly = true;
			this.readWriteTimeDifference4.Size = new System.Drawing.Size(72, 22);
			this.readWriteTimeDifference4.TabIndex = 2;
			this.readWriteTimeDifference4.Text = "";
			// 
			// readWriteTimeDifference3
			// 
			this.readWriteTimeDifference3.Location = new System.Drawing.Point(307, 336);
			this.readWriteTimeDifference3.Name = "readWriteTimeDifference3";
			this.readWriteTimeDifference3.ReadOnly = true;
			this.readWriteTimeDifference3.Size = new System.Drawing.Size(72, 22);
			this.readWriteTimeDifference3.TabIndex = 2;
			this.readWriteTimeDifference3.Text = "";
			// 
			// readWriteTimeDifference2
			// 
			this.readWriteTimeDifference2.Location = new System.Drawing.Point(225, 336);
			this.readWriteTimeDifference2.Name = "readWriteTimeDifference2";
			this.readWriteTimeDifference2.ReadOnly = true;
			this.readWriteTimeDifference2.Size = new System.Drawing.Size(72, 22);
			this.readWriteTimeDifference2.TabIndex = 2;
			this.readWriteTimeDifference2.Text = "";
			// 
			// readWriteTimeDifference1
			// 
			this.readWriteTimeDifference1.Location = new System.Drawing.Point(143, 336);
			this.readWriteTimeDifference1.Name = "readWriteTimeDifference1";
			this.readWriteTimeDifference1.ReadOnly = true;
			this.readWriteTimeDifference1.Size = new System.Drawing.Size(72, 22);
			this.readWriteTimeDifference1.TabIndex = 2;
			this.readWriteTimeDifference1.Text = "";
			// 
			// resumeButton
			// 
			this.resumeButton.Location = new System.Drawing.Point(123, 375);
			this.resumeButton.Name = "resumeButton";
			this.resumeButton.Size = new System.Drawing.Size(96, 28);
			this.resumeButton.TabIndex = 3;
			this.resumeButton.Text = "Wznw";
			this.resumeButton.Click += new System.EventHandler(this.OnResume);
			// 
			// suspendButton
			// 
			this.suspendButton.Location = new System.Drawing.Point(10, 375);
			this.suspendButton.Name = "suspendButton";
			this.suspendButton.Size = new System.Drawing.Size(96, 28);
			this.suspendButton.TabIndex = 3;
			this.suspendButton.Text = "Zawie";
			this.suspendButton.Click += new System.EventHandler(this.OnSuspend);
			// 
			// cyan5
			// 
			this.cyan5.Location = new System.Drawing.Point(471, 217);
			this.cyan5.Name = "cyan5";
			this.cyan5.ReadOnly = true;
			this.cyan5.Size = new System.Drawing.Size(72, 22);
			this.cyan5.TabIndex = 2;
			this.cyan5.Text = "";
			// 
			// cyan4
			// 
			this.cyan4.Location = new System.Drawing.Point(389, 217);
			this.cyan4.Name = "cyan4";
			this.cyan4.ReadOnly = true;
			this.cyan4.Size = new System.Drawing.Size(72, 22);
			this.cyan4.TabIndex = 2;
			this.cyan4.Text = "";
			// 
			// cyan3
			// 
			this.cyan3.Location = new System.Drawing.Point(307, 217);
			this.cyan3.Name = "cyan3";
			this.cyan3.ReadOnly = true;
			this.cyan3.Size = new System.Drawing.Size(72, 22);
			this.cyan3.TabIndex = 2;
			this.cyan3.Text = "";
			// 
			// cyan2
			// 
			this.cyan2.Location = new System.Drawing.Point(225, 217);
			this.cyan2.Name = "cyan2";
			this.cyan2.ReadOnly = true;
			this.cyan2.Size = new System.Drawing.Size(72, 22);
			this.cyan2.TabIndex = 2;
			this.cyan2.Text = "";
			// 
			// grayLabel
			// 
			this.grayLabel.BackColor = System.Drawing.Color.Gray;
			this.grayLabel.Location = new System.Drawing.Point(10, 247);
			this.grayLabel.Name = "grayLabel";
			this.grayLabel.Size = new System.Drawing.Size(128, 20);
			this.grayLabel.TabIndex = 1;
			this.grayLabel.Text = "Szara";
			// 
			// total5
			// 
			this.total5.Location = new System.Drawing.Point(471, 276);
			this.total5.Name = "total5";
			this.total5.ReadOnly = true;
			this.total5.Size = new System.Drawing.Size(72, 22);
			this.total5.TabIndex = 2;
			this.total5.Text = "";
			// 
			// timeLabel1
			// 
			this.timeLabel1.Location = new System.Drawing.Point(143, 316);
			this.timeLabel1.Name = "timeLabel1";
			this.timeLabel1.Size = new System.Drawing.Size(62, 20);
			this.timeLabel1.TabIndex = 1;
			this.timeLabel1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.timeLabel1.Visible = false;
			// 
			// timeLabel3
			// 
			this.timeLabel3.Location = new System.Drawing.Point(307, 316);
			this.timeLabel3.Name = "timeLabel3";
			this.timeLabel3.Size = new System.Drawing.Size(62, 20);
			this.timeLabel3.TabIndex = 1;
			this.timeLabel3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.timeLabel3.Visible = false;
			// 
			// timeLabel2
			// 
			this.timeLabel2.Location = new System.Drawing.Point(225, 316);
			this.timeLabel2.Name = "timeLabel2";
			this.timeLabel2.Size = new System.Drawing.Size(62, 20);
			this.timeLabel2.TabIndex = 1;
			this.timeLabel2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.timeLabel2.Visible = false;
			// 
			// timeLabel5
			// 
			this.timeLabel5.Location = new System.Drawing.Point(471, 316);
			this.timeLabel5.Name = "timeLabel5";
			this.timeLabel5.Size = new System.Drawing.Size(61, 20);
			this.timeLabel5.TabIndex = 1;
			this.timeLabel5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.timeLabel5.Visible = false;
			// 
			// timeLabel4
			// 
			this.timeLabel4.Location = new System.Drawing.Point(389, 316);
			this.timeLabel4.Name = "timeLabel4";
			this.timeLabel4.Size = new System.Drawing.Size(62, 20);
			this.timeLabel4.TabIndex = 1;
			this.timeLabel4.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.timeLabel4.Visible = false;
			// 
			// total1
			// 
			this.total1.Location = new System.Drawing.Point(143, 276);
			this.total1.Name = "total1";
			this.total1.ReadOnly = true;
			this.total1.Size = new System.Drawing.Size(72, 22);
			this.total1.TabIndex = 2;
			this.total1.Text = "";
			// 
			// total2
			// 
			this.total2.Location = new System.Drawing.Point(225, 276);
			this.total2.Name = "total2";
			this.total2.ReadOnly = true;
			this.total2.Size = new System.Drawing.Size(72, 22);
			this.total2.TabIndex = 2;
			this.total2.Text = "";
			// 
			// total3
			// 
			this.total3.Location = new System.Drawing.Point(307, 276);
			this.total3.Name = "total3";
			this.total3.ReadOnly = true;
			this.total3.Size = new System.Drawing.Size(72, 22);
			this.total3.TabIndex = 2;
			this.total3.Text = "";
			// 
			// total4
			// 
			this.total4.Location = new System.Drawing.Point(389, 276);
			this.total4.Name = "total4";
			this.total4.ReadOnly = true;
			this.total4.Size = new System.Drawing.Size(72, 22);
			this.total4.TabIndex = 2;
			this.total4.Text = "";
			// 
			// cyanLabel
			// 
			this.cyanLabel.BackColor = System.Drawing.Color.Cyan;
			this.cyanLabel.Location = new System.Drawing.Point(10, 217);
			this.cyanLabel.Name = "cyanLabel";
			this.cyanLabel.Size = new System.Drawing.Size(128, 20);
			this.cyanLabel.TabIndex = 1;
			this.cyanLabel.Text = "Cyjan";
			// 
			// yellow4
			// 
			this.yellow4.Location = new System.Drawing.Point(389, 158);
			this.yellow4.Name = "yellow4";
			this.yellow4.ReadOnly = true;
			this.yellow4.Size = new System.Drawing.Size(72, 22);
			this.yellow4.TabIndex = 2;
			this.yellow4.Text = "";
			// 
			// blue4
			// 
			this.blue4.Location = new System.Drawing.Point(389, 99);
			this.blue4.Name = "blue4";
			this.blue4.ReadOnly = true;
			this.blue4.Size = new System.Drawing.Size(72, 22);
			this.blue4.TabIndex = 2;
			this.blue4.Text = "";
			// 
			// blue5
			// 
			this.blue5.Location = new System.Drawing.Point(471, 99);
			this.blue5.Name = "blue5";
			this.blue5.ReadOnly = true;
			this.blue5.Size = new System.Drawing.Size(72, 22);
			this.blue5.TabIndex = 2;
			this.blue5.Text = "";
			// 
			// exitButton
			// 
			this.exitButton.Location = new System.Drawing.Point(440, 375);
			this.exitButton.Name = "exitButton";
			this.exitButton.Size = new System.Drawing.Size(96, 28);
			this.exitButton.TabIndex = 3;
			this.exitButton.Text = "Wyjd";
			this.exitButton.Click += new System.EventHandler(this.OnExit);
			// 
			// red5
			// 
			this.red5.Location = new System.Drawing.Point(471, 39);
			this.red5.Name = "red5";
			this.red5.ReadOnly = true;
			this.red5.Size = new System.Drawing.Size(72, 22);
			this.red5.TabIndex = 2;
			this.red5.Text = "";
			// 
			// red4
			// 
			this.red4.Location = new System.Drawing.Point(389, 39);
			this.red4.Name = "red4";
			this.red4.ReadOnly = true;
			this.red4.Size = new System.Drawing.Size(72, 22);
			this.red4.TabIndex = 2;
			this.red4.Text = "";
			// 
			// blue1
			// 
			this.blue1.Location = new System.Drawing.Point(143, 99);
			this.blue1.Name = "blue1";
			this.blue1.ReadOnly = true;
			this.blue1.Size = new System.Drawing.Size(72, 22);
			this.blue1.TabIndex = 2;
			this.blue1.Text = "";
			// 
			// blue2
			// 
			this.blue2.Location = new System.Drawing.Point(225, 99);
			this.blue2.Name = "blue2";
			this.blue2.ReadOnly = true;
			this.blue2.Size = new System.Drawing.Size(72, 22);
			this.blue2.TabIndex = 2;
			this.blue2.Text = "";
			// 
			// blue3
			// 
			this.blue3.Location = new System.Drawing.Point(307, 99);
			this.blue3.Name = "blue3";
			this.blue3.ReadOnly = true;
			this.blue3.Size = new System.Drawing.Size(72, 22);
			this.blue3.TabIndex = 2;
			this.blue3.Text = "";
			// 
			// readWriteTimeLabel
			// 
			this.readWriteTimeLabel.Location = new System.Drawing.Point(10, 336);
			this.readWriteTimeLabel.Name = "readWriteTimeLabel";
			this.readWriteTimeLabel.Size = new System.Drawing.Size(128, 19);
			this.readWriteTimeLabel.TabIndex = 1;
			this.readWriteTimeLabel.Text = "Czas odczytu/zapisu";
			// 
			// gray5
			// 
			this.gray5.Location = new System.Drawing.Point(471, 247);
			this.gray5.Name = "gray5";
			this.gray5.ReadOnly = true;
			this.gray5.Size = new System.Drawing.Size(72, 22);
			this.gray5.TabIndex = 2;
			this.gray5.Text = "";
			// 
			// black5
			// 
			this.black5.Location = new System.Drawing.Point(471, 10);
			this.black5.Name = "black5";
			this.black5.ReadOnly = true;
			this.black5.Size = new System.Drawing.Size(72, 22);
			this.black5.TabIndex = 2;
			this.black5.Text = "";
			// 
			// blackLabel
			// 
			this.blackLabel.BackColor = System.Drawing.SystemColors.ControlText;
			this.blackLabel.ForeColor = System.Drawing.SystemColors.Control;
			this.blackLabel.Location = new System.Drawing.Point(10, 10);
			this.blackLabel.Name = "blackLabel";
			this.blackLabel.Size = new System.Drawing.Size(128, 20);
			this.blackLabel.TabIndex = 1;
			this.blackLabel.Text = "Czarna";
			// 
			// yellow3
			// 
			this.yellow3.Location = new System.Drawing.Point(307, 158);
			this.yellow3.Name = "yellow3";
			this.yellow3.ReadOnly = true;
			this.yellow3.Size = new System.Drawing.Size(72, 22);
			this.yellow3.TabIndex = 2;
			this.yellow3.Text = "";
			// 
			// black1
			// 
			this.black1.Location = new System.Drawing.Point(143, 10);
			this.black1.Name = "black1";
			this.black1.ReadOnly = true;
			this.black1.Size = new System.Drawing.Size(72, 22);
			this.black1.TabIndex = 2;
			this.black1.Text = "";
			// 
			// black3
			// 
			this.black3.Location = new System.Drawing.Point(307, 10);
			this.black3.Name = "black3";
			this.black3.ReadOnly = true;
			this.black3.Size = new System.Drawing.Size(72, 22);
			this.black3.TabIndex = 2;
			this.black3.Text = "";
			// 
			// black2
			// 
			this.black2.Location = new System.Drawing.Point(225, 10);
			this.black2.Name = "black2";
			this.black2.ReadOnly = true;
			this.black2.Size = new System.Drawing.Size(72, 22);
			this.black2.TabIndex = 2;
			this.black2.Text = "";
			// 
			// cyan1
			// 
			this.cyan1.Location = new System.Drawing.Point(143, 217);
			this.cyan1.Name = "cyan1";
			this.cyan1.ReadOnly = true;
			this.cyan1.Size = new System.Drawing.Size(72, 22);
			this.cyan1.TabIndex = 2;
			this.cyan1.Text = "";
			// 
			// redLabel
			// 
			this.redLabel.BackColor = System.Drawing.Color.Red;
			this.redLabel.Location = new System.Drawing.Point(10, 39);
			this.redLabel.Name = "redLabel";
			this.redLabel.Size = new System.Drawing.Size(128, 20);
			this.redLabel.TabIndex = 1;
			this.redLabel.Text = "Czerwona";
			// 
			// orange2
			// 
			this.orange2.Location = new System.Drawing.Point(225, 188);
			this.orange2.Name = "orange2";
			this.orange2.ReadOnly = true;
			this.orange2.Size = new System.Drawing.Size(72, 22);
			this.orange2.TabIndex = 2;
			this.orange2.Text = "";
			// 
			// orange3
			// 
			this.orange3.Location = new System.Drawing.Point(307, 188);
			this.orange3.Name = "orange3";
			this.orange3.ReadOnly = true;
			this.orange3.Size = new System.Drawing.Size(72, 22);
			this.orange3.TabIndex = 2;
			this.orange3.Text = "";
			// 
			// orange1
			// 
			this.orange1.Location = new System.Drawing.Point(143, 188);
			this.orange1.Name = "orange1";
			this.orange1.ReadOnly = true;
			this.orange1.Size = new System.Drawing.Size(72, 22);
			this.orange1.TabIndex = 2;
			this.orange1.Text = "";
			// 
			// orange4
			// 
			this.orange4.Location = new System.Drawing.Point(389, 188);
			this.orange4.Name = "orange4";
			this.orange4.ReadOnly = true;
			this.orange4.Size = new System.Drawing.Size(72, 22);
			this.orange4.TabIndex = 2;
			this.orange4.Text = "";
			// 
			// orange5
			// 
			this.orange5.Location = new System.Drawing.Point(471, 188);
			this.orange5.Name = "orange5";
			this.orange5.ReadOnly = true;
			this.orange5.Size = new System.Drawing.Size(72, 22);
			this.orange5.TabIndex = 2;
			this.orange5.Text = "";
			// 
			// totalLabel
			// 
			this.totalLabel.Location = new System.Drawing.Point(10, 276);
			this.totalLabel.Name = "totalLabel";
			this.totalLabel.Size = new System.Drawing.Size(128, 20);
			this.totalLabel.TabIndex = 1;
			this.totalLabel.Text = "Suma";
			// 
			// blueLabel
			// 
			this.blueLabel.BackColor = System.Drawing.Color.Blue;
			this.blueLabel.Location = new System.Drawing.Point(10, 99);
			this.blueLabel.Name = "blueLabel";
			this.blueLabel.Size = new System.Drawing.Size(128, 19);
			this.blueLabel.TabIndex = 1;
			this.blueLabel.Text = "Niebieska";
			// 
			// black4
			// 
			this.black4.Location = new System.Drawing.Point(389, 10);
			this.black4.Name = "black4";
			this.black4.ReadOnly = true;
			this.black4.Size = new System.Drawing.Size(72, 22);
			this.black4.TabIndex = 2;
			this.black4.Text = "";
			// 
			// white2
			// 
			this.white2.Location = new System.Drawing.Point(225, 128);
			this.white2.Name = "white2";
			this.white2.ReadOnly = true;
			this.white2.Size = new System.Drawing.Size(72, 22);
			this.white2.TabIndex = 2;
			this.white2.Text = "";
			// 
			// yellowLabel
			// 
			this.yellowLabel.BackColor = System.Drawing.Color.Yellow;
			this.yellowLabel.Location = new System.Drawing.Point(10, 158);
			this.yellowLabel.Name = "yellowLabel";
			this.yellowLabel.Size = new System.Drawing.Size(128, 20);
			this.yellowLabel.TabIndex = 1;
			this.yellowLabel.Text = "ta";
			// 
			// white5
			// 
			this.white5.Location = new System.Drawing.Point(471, 128);
			this.white5.Name = "white5";
			this.white5.ReadOnly = true;
			this.white5.Size = new System.Drawing.Size(72, 22);
			this.white5.TabIndex = 2;
			this.white5.Text = "";
			// 
			// white4
			// 
			this.white4.Location = new System.Drawing.Point(389, 128);
			this.white4.Name = "white4";
			this.white4.ReadOnly = true;
			this.white4.Size = new System.Drawing.Size(72, 22);
			this.white4.TabIndex = 2;
			this.white4.Text = "";
			// 
			// white1
			// 
			this.white1.Location = new System.Drawing.Point(143, 128);
			this.white1.Name = "white1";
			this.white1.ReadOnly = true;
			this.white1.Size = new System.Drawing.Size(72, 22);
			this.white1.TabIndex = 2;
			this.white1.Text = "";
			// 
			// white3
			// 
			this.white3.Location = new System.Drawing.Point(307, 128);
			this.white3.Name = "white3";
			this.white3.ReadOnly = true;
			this.white3.Size = new System.Drawing.Size(72, 22);
			this.white3.TabIndex = 2;
			this.white3.Text = "";
			// 
			// greenLabel
			// 
			this.greenLabel.BackColor = System.Drawing.Color.Green;
			this.greenLabel.Location = new System.Drawing.Point(10, 69);
			this.greenLabel.Name = "greenLabel";
			this.greenLabel.Size = new System.Drawing.Size(128, 20);
			this.greenLabel.TabIndex = 1;
			this.greenLabel.Text = "Zielona";
			// 
			// gray4
			// 
			this.gray4.Location = new System.Drawing.Point(389, 247);
			this.gray4.Name = "gray4";
			this.gray4.ReadOnly = true;
			this.gray4.Size = new System.Drawing.Size(72, 22);
			this.gray4.TabIndex = 2;
			this.gray4.Text = "";
			// 
			// gray3
			// 
			this.gray3.Location = new System.Drawing.Point(307, 247);
			this.gray3.Name = "gray3";
			this.gray3.ReadOnly = true;
			this.gray3.Size = new System.Drawing.Size(72, 22);
			this.gray3.TabIndex = 2;
			this.gray3.Text = "";
			// 
			// gray2
			// 
			this.gray2.Location = new System.Drawing.Point(225, 247);
			this.gray2.Name = "gray2";
			this.gray2.ReadOnly = true;
			this.gray2.Size = new System.Drawing.Size(72, 22);
			this.gray2.TabIndex = 2;
			this.gray2.Text = "";
			// 
			// gray1
			// 
			this.gray1.Location = new System.Drawing.Point(143, 247);
			this.gray1.Name = "gray1";
			this.gray1.ReadOnly = true;
			this.gray1.Size = new System.Drawing.Size(72, 22);
			this.gray1.TabIndex = 2;
			this.gray1.Text = "";
			// 
			// yellow5
			// 
			this.yellow5.Location = new System.Drawing.Point(471, 158);
			this.yellow5.Name = "yellow5";
			this.yellow5.ReadOnly = true;
			this.yellow5.Size = new System.Drawing.Size(72, 22);
			this.yellow5.TabIndex = 2;
			this.yellow5.Text = "";
			// 
			// yellow2
			// 
			this.yellow2.Location = new System.Drawing.Point(225, 158);
			this.yellow2.Name = "yellow2";
			this.yellow2.ReadOnly = true;
			this.yellow2.Size = new System.Drawing.Size(72, 22);
			this.yellow2.TabIndex = 2;
			this.yellow2.Text = "";
			// 
			// whiteLabel
			// 
			this.whiteLabel.BackColor = System.Drawing.Color.White;
			this.whiteLabel.Location = new System.Drawing.Point(10, 128);
			this.whiteLabel.Name = "whiteLabel";
			this.whiteLabel.Size = new System.Drawing.Size(128, 20);
			this.whiteLabel.TabIndex = 1;
			this.whiteLabel.Text = "Biaa";
			// 
			// yellow1
			// 
			this.yellow1.Location = new System.Drawing.Point(143, 158);
			this.yellow1.Name = "yellow1";
			this.yellow1.ReadOnly = true;
			this.yellow1.Size = new System.Drawing.Size(72, 22);
			this.yellow1.TabIndex = 2;
			this.yellow1.Text = "";
			// 
			// red1
			// 
			this.red1.Location = new System.Drawing.Point(143, 39);
			this.red1.Name = "red1";
			this.red1.ReadOnly = true;
			this.red1.Size = new System.Drawing.Size(72, 22);
			this.red1.TabIndex = 2;
			this.red1.Text = "";
			// 
			// red3
			// 
			this.red3.Location = new System.Drawing.Point(307, 39);
			this.red3.Name = "red3";
			this.red3.ReadOnly = true;
			this.red3.Size = new System.Drawing.Size(72, 22);
			this.red3.TabIndex = 2;
			this.red3.Text = "";
			// 
			// red2
			// 
			this.red2.Location = new System.Drawing.Point(225, 39);
			this.red2.Name = "red2";
			this.red2.ReadOnly = true;
			this.red2.Size = new System.Drawing.Size(72, 22);
			this.red2.TabIndex = 2;
			this.red2.Text = "";
			// 
			// BucketForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(552, 420);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.timeLabel5,
																		  this.timeLabel4,
																		  this.timeLabel3,
																		  this.timeLabel2,
																		  this.timeLabel1,
																		  this.readWriteTimeLabel,
																		  this.exitButton,
																		  this.resumeButton,
																		  this.suspendButton,
																		  this.readWriteTimeDifference5,
																		  this.readWriteTimeDifference4,
																		  this.readWriteTimeDifference3,
																		  this.readWriteTimeDifference2,
																		  this.readWriteTimeDifference1,
																		  this.gray5,
																		  this.yellow5,
																		  this.orange5,
																		  this.green5,
																		  this.red5,
																		  this.black5,
																		  this.blue5,
																		  this.cyan5,
																		  this.total5,
																		  this.white5,
																		  this.black4,
																		  this.black1,
																		  this.black3,
																		  this.black2,
																		  this.red4,
																		  this.red1,
																		  this.red3,
																		  this.red2,
																		  this.green4,
																		  this.green1,
																		  this.green3,
																		  this.green2,
																		  this.blue4,
																		  this.blue1,
																		  this.blue3,
																		  this.blue2,
																		  this.white4,
																		  this.white1,
																		  this.white3,
																		  this.white2,
																		  this.yellow4,
																		  this.yellow1,
																		  this.yellow3,
																		  this.yellow2,
																		  this.orange4,
																		  this.orange1,
																		  this.orange3,
																		  this.orange2,
																		  this.cyan4,
																		  this.cyan1,
																		  this.cyan3,
																		  this.cyan2,
																		  this.gray4,
																		  this.gray3,
																		  this.gray2,
																		  this.gray1,
																		  this.total4,
																		  this.total3,
																		  this.total2,
																		  this.total1,
																		  this.blackLabel,
																		  this.redLabel,
																		  this.greenLabel,
																		  this.blueLabel,
																		  this.whiteLabel,
																		  this.yellowLabel,
																		  this.orangeLabel,
																		  this.cyanLabel,
																		  this.grayLabel,
																		  this.totalLabel});
			this.Name = "BucketForm";
			this.Text = "Demonstracja funkcji odczytu i zapisu";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.OnClosing);
			this.Load += new System.EventHandler(this.OnLoad);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new BucketForm());
		}

		private void OnSuspend(object sender, System.EventArgs e)
		{
			foreach(Thread t in writerThreads)
			{
				t.Suspend();
			}
			foreach(Thread t in readerThreads)
			{
				t.Suspend();
			}
			int [] tempArray = new int[readerTimeStamp.Length];
			int [] tempIndex = new int[readerTimeStamp.Length];
			for(int i = 0; i < readerTimeStamp.Length; i++)
			{
				tempArray[i] = readerTimeStamp[i];
				tempIndex[i] = i;
			}
			Array.Sort(tempArray, tempIndex);
			for(int i = 0; i < readerTimeStamp.Length; i++)
			{
				switch(tempIndex[i])
				{
					case 0:
						timeLabel1.Text = Convert.ToString(i);
						timeLabel1.Visible = true;
						if(readerTimeStamp[0] < writerTimeStamp[0] ||
                           readerTimeStamp[0] < writerTimeStamp[1] ||
                           readerTimeStamp[0] < writerTimeStamp[2] ||
                           readerTimeStamp[0] < writerTimeStamp[3] ||
                           readerTimeStamp[0] < writerTimeStamp[4])
							timeLabel1.BackColor = Color.Red;
						else
							timeLabel1.BackColor = Color.FromKnownColor(KnownColor.Control);
						break;
					case 1:
						timeLabel2.Text = Convert.ToString(i);
						timeLabel2.Visible = true;
						if(readerTimeStamp[1] < writerTimeStamp[0] ||
						   readerTimeStamp[1] < writerTimeStamp[1] ||
						   readerTimeStamp[1] < writerTimeStamp[2] ||
						   readerTimeStamp[1] < writerTimeStamp[3] ||
						   readerTimeStamp[1] < writerTimeStamp[4])
							timeLabel2.BackColor = Color.Red;
						else
							timeLabel2.BackColor = Color.FromKnownColor(KnownColor.Control);
						break;
					case 2:
						timeLabel3.Text = Convert.ToString(i);
						timeLabel3.Visible = true;
						if(readerTimeStamp[2] < writerTimeStamp[0] ||
						   readerTimeStamp[2] < writerTimeStamp[1] ||
						   readerTimeStamp[2] < writerTimeStamp[2] ||
						   readerTimeStamp[2] < writerTimeStamp[3] ||
						   readerTimeStamp[2] < writerTimeStamp[4])
							timeLabel3.BackColor = Color.Red;
						else
							timeLabel3.BackColor = Color.FromKnownColor(KnownColor.Control);
						break;
					case 3:
						timeLabel4.Text = Convert.ToString(i);
						timeLabel4.Visible = true;
						if(readerTimeStamp[3] < writerTimeStamp[0] ||
						   readerTimeStamp[3] < writerTimeStamp[1] ||
					       readerTimeStamp[3] < writerTimeStamp[2] ||
						   readerTimeStamp[3] < writerTimeStamp[3] ||
						   readerTimeStamp[3] < writerTimeStamp[4])
							timeLabel4.BackColor = Color.Red;
						else
							timeLabel4.BackColor = Color.FromKnownColor(KnownColor.Control);
						break;
					case 4:
						timeLabel5.Text = Convert.ToString(i);
						timeLabel5.Visible = true;
						if(readerTimeStamp[4] < writerTimeStamp[0] ||
						   readerTimeStamp[4] < writerTimeStamp[1] ||
						   readerTimeStamp[4] < writerTimeStamp[2] ||
						   readerTimeStamp[4] < writerTimeStamp[3] ||
						   readerTimeStamp[4] < writerTimeStamp[4])
							timeLabel5.BackColor = Color.Red;
						else
							timeLabel5.BackColor = Color.FromKnownColor(KnownColor.Control);
						break;
				}
			}
		}

		private void OnResume(object sender, System.EventArgs e)
		{
			timeLabel1.Visible = false;
			timeLabel2.Visible = false;
			timeLabel3.Visible = false;
			timeLabel4.Visible = false;
			timeLabel5.Visible = false;

			try
			{
				foreach(Thread t in readerThreads)
				{
					t.Resume();
				}
				foreach(Thread t in writerThreads)
				{
					t.Resume();
				}
			}
			catch(Exception exception)
			{
				Debug.WriteLine("Bd wznowienia: " + exception.ToString());
			}
		}

		private void OnExit(object sender, System.EventArgs e)
		{
			System.Threading.ThreadState state;
			foreach(Thread t in readerThreads)
			{
				state = t.ThreadState;
				Debug.WriteLine("Stan wtku odczytu w czasie wyjcia " + state.ToString());
				// Zawieszony wtek musi by wznowiony, gdy w przeciwnym wypadku zgaszany
				// jest wyjtek, a proces nigdy si nie koczy.
				if((state & System.Threading.ThreadState.Suspended) != 0 ||
					(state & System.Threading.ThreadState.SuspendRequested) != 0)
					t.Resume();
				t.Abort();
				t.Join();
			}
			foreach(Thread t in writerThreads)
			{
				state = t.ThreadState;
				Debug.WriteLine("Stan wtku zapisu w czasie wyjcia " + state.ToString());
				// Zawieszony wtek musi by wznowiony, gdy w przeciwnym wypadku zgaszany
				// jest wyjtek, a proces nigdy si nie koczy.
				if((state & System.Threading.ThreadState.Suspended) != 0 ||
					(state & System.Threading.ThreadState.SuspendRequested) != 0)
					t.Resume();
				t.Abort();
				t.Join();
			}
			Application.Exit();
		}

		private void OnClosing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			System.Threading.ThreadState state;
			foreach(Thread t in readerThreads)
			{
				state = t.ThreadState;
				// Zawieszony wtek musi by wznowiony, gdy w przeciwnym wypadku zgaszany
				// jest wyjtek, a proces nigdy si nie koczy.
				if((state & System.Threading.ThreadState.Suspended) != 0 ||
					(state & System.Threading.ThreadState.SuspendRequested) != 0)
					t.Resume();
				t.Abort();
				t.Join();
			}
			foreach(Thread t in writerThreads)
			{
				state = t.ThreadState;
				// Zawieszony wtek musi by wznowiony, gdy w przeciwnym wypadku zgaszany
				// jest wyjtek, a proces nigdy si nie koczy.
				if((state & System.Threading.ThreadState.Suspended) != 0 ||
					(state & System.Threading.ThreadState.SuspendRequested) != 0)
					t.Resume();
				t.Abort();
				t.Join();
			}
		}

		private void OnLoad(object sender, System.EventArgs e)
		{
			for(int i = 0; i < readerCount; i++)
			{
				readerTimeStamp[i] = 0;
				readerThreads[i].Start();
			}
			for(int i = 0; i < writerCount; i++)
			{
				writerTimeStamp[i] = 0;
				writerThreads[i].Start();
			}
		}
	}
}
